package fr.asip.cps3.exemple.modele.resultats;

/**
 * Classe reprsentant le rsultat de gnration de signature d'un fichier
 */
public class ResultatSignatureFichier extends ResultatTriple {

	/**
	 * La signature
	 */
	private String signature;

	/**
	 * Constructeur
	 * @param operation1 Description de la premire opration
	 * @param operation2 Description de la deuxime opration
	 * @param operation3 Description de la troisime opration
	 */
	public ResultatSignatureFichier(String operation1, String operation2, String operation3){
		this(operation1, operation2, operation3, "");
	}
	
	/**
	 * Constructeur
	 * @param operation1 Description de la premire opration
	 * @param operation2 Description de la deuxime opration
	 * @param operation3 Description de la troisime opration
	 * @param signature La signature
	 */
	public ResultatSignatureFichier(String operation1, String operation2, String operation3, String signature){
		super(operation1, operation2, operation3);
		this.signature = signature;
	}
	
	/**
	 * Accesseur
	 * @return La signature
	 */
	public String getSignature() {
		return this.signature;
	}

	/**
	 * Mutateur
	 * @param signature La signature
	 */
	public void setSignature(String signature) {
		this.signature = signature;
	}

}
